<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;

class LanggananController extends Controller
{
    
	
	function nopol(){
		
		$rs = DB::table("membernopol")
		->leftJoin("mastercompany","mastercompany.company_id","=","membernopol.company_id")
		->selectRaw('mastercompany.company_id, mastercompany.company_name, count(*) as qty')
		->groupBy("mastercompany.company_id","mastercompany.company_name")
		->orderBy("qty","desc")
		->get();
		//dd($rs);
		$data['data'] = $rs;
		
		$rs2 = DB::table("membernopol")
		->leftJoin("masterproduct","masterproduct.productcode","=","membernopol.productcode")
		->selectRaw('masterproduct.productcode,masterproduct.productname, count(*) as qty')
		->groupBy("masterproduct.productcode","masterproduct.productname")
		->orderBy("qty","desc")
		->get();
		//dd($rs);
		$data['produk'] = $rs2;
		
		
		$data['title'] = "Data Langganan Nopol";
		$data['total']= $rs->count();
		//dd($rs);
		
		return view("langganan_nopol",$data);
	}
	public function nopol_detail(Request $r){
		$type = $r->type;
		if($type == "tenant"){
			$rs = DB::table("membernopol")
			->leftJoin("mastercompany","mastercompany.company_id","=","membernopol.company_id")
			->leftJoin("masterproduct","masterproduct.productcode","=","membernopol.productcode")
			->where("membernopol.company_id",$r->id)
			->get();
			
			
		}
		else{
			$rs = DB::table("membernopol")
			->leftJoin("mastercompany","mastercompany.company_id","=","membernopol.company_id")
			->leftJoin("masterproduct","masterproduct.productcode","=","membernopol.productcode")
			->where("membernopol.productcode",$r->id)
			->get();
		}
		$no = 0;
		$html = "<table class='table table-striped' id='tbldetail'>
		<thead>
		<tr>
		<th>No</th>
		<th>Nama</th>
		<th>Tenant</th>
		<th>Nomor Polisi</th>
		<th>Produk</th>
		<th>Tanggal Mulai</th>
		<th>Tanggal Selesai</th>
		</thead>
		<tbody>
		";
		foreach($rs as $row){
			$no++;
			$html .= "<tr>
			<td>".$no."</td>
			<td nowrap>".$row->member_name."</td>
			<td td nowrap>".$row->company_name."</td>
			<td>".$row->policeno."</td>
			<td nowrap>".$row->productname."</td>
			<td nowrap>".date_format(date_create($row->startdate),'d M y')."</td>
			<td nowrap>".date_format(date_create($row->enddate),'d M y')."</td>
			</tr>";
		}
		$html .= "</tbody></table>";
		return $html;
	}
	
	function kartu(){
		
		$rs = DB::table("membercard")
		->leftJoin("mastercompany","mastercompany.company_id","=","membercard.company_id")
		->selectRaw('mastercompany.company_id, mastercompany.company_name, count(*) as qty')
		->groupBy("mastercompany.company_id","mastercompany.company_name")
		->orderBy("qty","desc")
		->get();
		//dd($rs);
		$data['data'] = $rs;
		
		$rs2 = DB::table("membercard")
		->leftJoin("masterproduct","masterproduct.productcode","=","membercard.productcode")
		->selectRaw('masterproduct.productcode,masterproduct.productname, count(*) as qty')
		->groupBy("masterproduct.productcode","masterproduct.productname")
		->orderBy("qty","desc")
		->get();
		//dd($rs);
		$data['produk'] = $rs2;
		
		
		$data['title'] = "Data Langganan Kartu";
		$data['total']= $rs->count();
		//dd($rs);
		
		return view("langganan_kartu",$data);
	}
	public function kartu_detail(Request $r){
		$type = $r->type;
		if($type == "tenant"){
			$rs = DB::table("membercard")
			->leftJoin("mastercompany","mastercompany.company_id","=","membercard.company_id")
			->leftJoin("masterproduct","masterproduct.productcode","=","membercard.productcode")
			->where("membercard.company_id",$r->id)
			->get();
			
			
		}
		else{
			$rs = DB::table("membercard")
			->leftJoin("mastercompany","mastercompany.company_id","=","membercard.company_id")
			->leftJoin("masterproduct","masterproduct.productcode","=","membercard.productcode")
			->where("membercard.productcode",$r->id)
			->get();
		}
		$no = 0;
		$html = "<table class='table table-striped' id='tbldetail'>
		<thead>
		<tr>
		<th>No</th>
		<th>Nama</th>
		<th>Tenant</th>
		<th>Nomor RFID</th>
		<th>Nomor Polisi</th>
		<th>Produk</th>
		<th>Tanggal Mulai</th>
		<th>Tanggal Selesai</th>
		</thead>
		<tbody>
		";
		foreach($rs as $row){
			$no++;
			$html .= "<tr>
			<td>".$no."</td>
			<td nowrap>".$row->member_name."</td>
			<td td nowrap>".$row->company_name."</td>
			<td>".$row->cardno."</td>
			<td>".$row->policeno."</td>
			<td nowrap>".$row->productname."</td>
			<td nowrap>".date_format(date_create($row->startdate),'d M y')."</td>
			<td nowrap>".date_format(date_create($row->enddate),'d M y')."</td>
			</tr>";
		}
		$html .= "</tbody></table>";
		return $html;
	}
	
	function penjualan(){
		$data['title'] = "Data Penjualan Langganan";
		
		$tenant = DB::table("mastercompany")->get();
		$data['tenant'] = $tenant;
		return view("penjualan",$data);
	}
	
	function penjualan_data(Request $r){
		$dt1 = $r->date1." 00:00:00";
		$dt2 = $r->date2." 23:59:59";
		$tenant = $r->tenant;
		$query = DB::table("trpenjualan")
        ->leftJoin("mastercompany", "mastercompany.company_id", "=", "trpenjualan.pj_memberid")
        ->selectRaw("mastercompany.company_name, LEFT(trpenjualan.date_input, 10) as tanggal, COUNT(*) as qty, SUM(trpenjualan.pj_total) as total")
        ->whereBetween("trpenjualan.date_input", [$dt1, $dt2]); // Fixes the incorrect date range filtering

		if ($tenant !== "ALL") {
			$query->where("trpenjualan.pj_memberid", $tenant);
		}

		$rows = $query->groupBy(DB::raw("mastercompany.company_name, LEFT(trpenjualan.date_input, 10)"))
			->get();
		
		$html = "<table class='table table-striped table-bordered'><thead>";
		$html .= "<tr><th>Tenant</th><th>Tanggal</th><th>Qty</th><th>Amount</th></tr></thead>";
		$html .= "<tbody>";
		$total = 0;
		foreach($rows as $row){
			$total += $row->total;
			$html .="<tr><td>".$row->company_name."</td><td>".date_format(date_create($row->tanggal),"d F Y")."</td><td align=right>".number_format($row->qty)."</td><td align=right>".number_format($row->total)."</td></tr>";
		}
		$html .= "</tbody><tfoot><tr><td colspan=3>TOTAL</td><td align=right>".number_format($total)."</td></tr></table>";
		
		return $html;
		
	}
}
