<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;

class DashboardControllerMonthly extends Controller
{
    function monthly(){
		$data['title'] = "Pendapatan Bulanan";
		$data['title2'] = "Parking income summary for daily, weekly and monthly";
		return view("monthly",$data);
	}
	function monthly_data(Request $r){
		$dt1 = $r->date1." 00:00:00";
		$dt2 = $r->date2." 23:59:59";
		$data = DB::table('parking_out')
		->whereBetween("datetimeout", [$dt1, $dt2])
		->selectRaw("LEFT(datetimeout, 7) AS tanggal")
		->selectRaw("sum(CASE WHEN vehicle = 'MOBIL' THEN 1 ELSE 0 END) AS qty_mobil")
		->selectRaw("sum(CASE WHEN vehicle = 'MOTOR' THEN 1 ELSE 0 END) AS qty_motor")
		->selectRaw("sum(CASE WHEN vehicle = 'BOX' THEN 1 ELSE 0 END) AS qty_box")
		->selectRaw("sum(CASE WHEN vehicle NOT IN('MOBIL','MOTOR','BOX') THEN 1 ELSE 0 END) AS qty_other")
		->selectRaw("SUM(CASE WHEN vehicle = 'MOBIL' THEN parking_fee ELSE 0 END) AS mobil")
		->selectRaw("SUM(CASE WHEN vehicle = 'MOTOR' THEN parking_fee ELSE 0 END) AS motor")
		->selectRaw("SUM(CASE WHEN vehicle = 'BOX' THEN parking_fee ELSE 0 END) AS box")
		->selectRaw("SUM(CASE WHEN vehicle NOT IN('MOBIL','MOTOR','BOX') THEN parking_fee ELSE 0 END) AS other")
		->groupBy(DB::RAW('left(datetimeout,7)'))
		->get();

		
		$table = "<br><br><table class='table table-striped table-bordered table-sm' style='width:100%'><thead style='background-color:#1abc9c;color:#FFF;text-align:center'>
			<tr>
				<th rowspan=2>Periode</th>
				<th colspan=2>Mobil</th>
				<th colspan=2>Motor</th>
				<th colspan=2>Box</th>
				<th colspan=2>Lainnya</th>
				<th colspan=2>Total</th>
			</tr>
				<th>Qty</th><th>Nominal</th>
				<th>Qty</th><th>Nominal</th>
				<th>Qty</th><th>Nominal</th>
				<th>Qty</th><th>Nominal</th>
				<th>Qty</th><th>Nominal</th>
			</tr>
		</thead><tbody>";
		$grandtotal = 0;
		$grandtotal_qty = 0;
		$subtotal_qty = 0;
		$subtotal = 0;
		$subtotal_mobil_qty = 0;
		$subtotal_mobil = 0;
		$subtotal_motor_qty = 0;
		$subtotal_motor = 0;
		$subtotal_box_qty = 0;
		$subtotal_box = 0;
		$subtotal_other_qty = 0;
		$subtotal_other = 0;
		foreach($data as $d){
			$subtotal_mobil_qty += $d->qty_mobil;
			$subtotal_mobil += $d->mobil;
			$subtotal_motor_qty += $d->qty_motor;
			$subtotal_motor += $d->motor;
			$subtotal_box_qty += $d->qty_box;
			$subtotal_box += $d->box;
			$subtotal_other_qty += $d->qty_other;
			$subtotal_other += $d->other;
			$subtotal_qty = $d->qty_motor + $d->qty_mobil + $d->qty_box +  $d->qty_other;
			$subtotal = $d->motor + $d->mobil + $d->box +  $d->other;
			$grandtotal += $subtotal;
			$grandtotal_qty += $subtotal_qty;
			$table .= "<tr>
							<td align=center>".date_format(date_create($d->tanggal),"M Y")."</td>
							<td align=right>".number_format($d->qty_mobil)."</td>
							<td align=right>".number_format($d->mobil)."</td>
							<td align=right>".number_format($d->qty_motor)."</td>
							<td align=right>".number_format($d->motor)."</td>
							<td align=right>".number_format($d->qty_box)."</td>
							<td align=right>".number_format($d->box)."</td>
							<td align=right>".number_format($d->qty_other)."</td>
							<td align=right>".number_format($d->other)."</td>
							<td align=right>".number_format($subtotal_qty)."</td>
							<td align=right>".number_format($subtotal)."</td>
							</tr>";
			$subtotal = 0;
					
		}
		$table .= "</tbody><tfoot style='background-color:#1abc9c;color:#FFF;font-weight:bolder'>
			<tr>
				<td>TOTAL</td>
				<td align=right>".number_format($subtotal_mobil_qty)."</td>
				<td align=right>".number_format($subtotal_mobil)."</td>
				<td align=right>".number_format($subtotal_motor_qty)."</td>
				<td align=right>".number_format($subtotal_motor)."</td>
				<td align=right>".number_format($subtotal_box_qty)."</td>
				<td align=right>".number_format($subtotal_box)."</td>
				<td align=right>".number_format($subtotal_other_qty)."</td>
				<td align=right>".number_format($subtotal_other)."</td>
				<td align=right>".number_format($grandtotal_qty)."</td>
				<td align=right>".number_format($grandtotal)."</td>
				</tr></tfoot>
				</table>";

		return $table;
		
	}
	function monthly_graphic(Request $r){
		$dt1 = $r->date1." 00:00:00";
		$dt2 = $r->date2." 23:59:59";
		
		$data = DB::table('parking_out')
		->whereBetween("datetimeout", [$dt1, $dt2])
		->selectRaw("DATE_FORMAT(datetimeout, '%b %y') AS tanggal")
		->selectRaw("SUM(CASE WHEN vehicle = 'MOBIL' THEN 1 ELSE 0 END) AS qty_mobil")
		->selectRaw("SUM(CASE WHEN vehicle = 'MOTOR' THEN 1 ELSE 0 END) AS qty_motor")
		->selectRaw("SUM(CASE WHEN vehicle = 'BOX' THEN 1 ELSE 0 END) AS qty_box")
		->selectRaw("SUM(CASE WHEN vehicle NOT IN ('MOBIL', 'MOTOR', 'BOX') THEN 1 ELSE 0 END) AS qty_other")
		->selectRaw("SUM(CASE WHEN vehicle = 'MOBIL' THEN parking_fee ELSE 0 END) AS mobil")
		->selectRaw("SUM(CASE WHEN vehicle = 'MOTOR' THEN parking_fee ELSE 0 END) AS motor")
		->selectRaw("SUM(CASE WHEN vehicle = 'BOX' THEN parking_fee ELSE 0 END) AS box")
		->selectRaw("SUM(CASE WHEN vehicle NOT IN ('MOBIL', 'MOTOR', 'BOX') THEN parking_fee ELSE 0 END) AS other")
		->groupBy(DB::raw("DATE_FORMAT(datetimeout, '%Y-%m')")) // Group by month-year format
		->orderByRaw("MIN(datetimeout)") // Ensure correct ordering
		->get();

		return response()->json($data);
	}
	
	function daily_graphic_pie(Request $r){
		$dt1 = $r->date1." 00:00:00";
		$dt2 = $r->date2." 23:59:59";
		
		$data = DB::table('parking_out')
		->whereBetween("datetimeout", [$dt1, $dt2])
		->selectRaw("left(tanggal,7) as tanggal")
		->selectRaw("sum(parking_fee) as amount")
		->selectRaw("count(*) as qty")
		->groupBy(DB::RAW('left(datetimeout,7)'))
		->get();

		return response()->json($data);
	}
}
